
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter sandwiches")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="cantaloupes")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="rotisserie chickens")

# Set objective function
m.setObjective(4*x0 + 1*x1 + 8*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.35*x1 + 1.27*x2 >= 10, "c1")
m.addConstr(0.3*x0 + 0.35*x1 >= 10, "c2")
m.addConstr(0.3*x0 + 0.35*x1 + 1.27*x2 >= 10, "c3")
m.addConstr(1.13*x0 + 0.09*x2 >= 4, "c4")
m.addConstr(1.13*x0 + 1.47*x1 >= 7, "c5")
m.addConstr(1.13*x0 + 1.47*x1 + 0.09*x2 >= 4, "c6")
m.addConstr(-8*x0 + 4*x1 >= 0, "c7")
m.addConstr(1.47*x1 + 0.09*x2 <= 23, "c8")


# Resource Constraints (implicit in problem description)
m.addConstr(0.3*x0 <= 30, "r0_x0")
m.addConstr(0.35*x1 <= 30, "r0_x1")
m.addConstr(1.27*x2 <= 30, "r0_x2")
m.addConstr(1.13*x0 <= 26, "r1_x0")
m.addConstr(1.47*x1 <= 26, "r1_x1")
m.addConstr(0.09*x2 <= 26, "r1_x2")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

