
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="cantaloupes", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="rotisserie_chickens")

    # Objective function
    model.setObjective(4*x0 + x1 + 8*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.35*x1 + 1.27*x2 >= 10)
    model.addConstr(0.3*x0 + 0.35*x1 >= 10)
    model.addConstr(1.13*x0 + 0.09*x2 >= 4)
    model.addConstr(1.13*x0 + 1.47*x1 >= 7)
    model.addConstr(1.13*x0 + 1.47*x1 + 0.09*x2 >= 4)
    model.addConstr(-8*x0 + 4*x1 >= 0)
    model.addConstr(1.47*x1 + 0.09*x2 <= 23)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Peanutbutter sandwiches: {x0.varValue}")
        print(f"Cantaloupes: {x1.varValue}")
        print(f"Rotisserie chickens: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
