
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.INTEGER, name=["water_purification", "pathfinder_teams", "light_infantry", "logistics_companies"])


    # Set objective function
    m.setObjective(9.92 * x[0] + 2.69 * x[1] + 8.0 * x[2] + 8.12 * x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12 * x[0] + 9 * x[1] + 11 * x[2] + 4 * x[3] <= 199, "logistics_footprint_limit")
    m.addConstr(9 * x[0] + 4 * x[1] + 6 * x[2] + 13 * x[3] <= 234, "mobility_rating_limit")
    m.addConstr(11 * x[2] + 4 * x[3] >= 31, "c1")
    m.addConstr(12 * x[0] + 11 * x[2] >= 39, "c2")
    m.addConstr(9 * x[1] + 4 * x[3] >= 29, "c3")
    m.addConstr(12 * x[0] + 4 * x[3] >= 40, "c4")
    m.addConstr(12 * x[0] + 9 * x[1] + 4 * x[3] >= 35, "c5")
    m.addConstr(6 * x[2] + 13 * x[3] >= 25, "c6")
    m.addConstr(9 * x[0] + 13 * x[3] >= 30, "c7")
    m.addConstr(11 * x[2] + 4 * x[3] <= 152, "c8")
    m.addConstr(9 * x[1] + 11 * x[2] <= 81, "c9")
    m.addConstr(12 * x[0] + 11 * x[2] <= 143, "c10")
    m.addConstr(9 * x[1] + 4 * x[3] <= 155, "c11")
    m.addConstr(12 * x[0] + 4 * x[3] <= 110, "c12")
    m.addConstr(12 * x[0] + 9 * x[1] + 11 * x[2] + 4 * x[3] <= 110, "c13")
    m.addConstr(4 * x[1] + 6 * x[2] <= 210, "c14")
    m.addConstr(6 * x[2] + 13 * x[3] <= 197, "c15")
    m.addConstr(9 * x[0] + 4 * x[1] + 6 * x[2] <= 73, "c16")
    m.addConstr(9 * x[0] + 4 * x[1] + 6 * x[2] + 13 * x[3] <= 73, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
