
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="pathfinder_teams", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="light_infantry_companies", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9.92 * x0 + 2.69 * x1 + 8.0 * x2 + 8.12 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * x0 + 9 * x1 + 11 * x2 + 4 * x3 <= 199)
    model.addConstr(9 * x0 + 4 * x1 + 6 * x2 + 13 * x3 <= 234)
    model.addConstr(11 * x2 + 4 * x3 >= 31)
    model.addConstr(12 * x0 + 4 * x3 >= 39)
    model.addConstr(9 * x1 + 4 * x3 >= 29)
    model.addConstr(12 * x0 + 4 * x3 >= 40)
    model.addConstr(12 * x0 + 9 * x1 + 4 * x3 >= 35)
    model.addConstr(6 * x2 + 13 * x3 >= 25)
    model.addConstr(9 * x0 + 13 * x3 >= 30)
    model.addConstr(11 * x2 + 4 * x3 <= 152)
    model.addConstr(9 * x1 + 11 * x2 <= 81)
    model.addConstr(12 * x0 + 11 * x2 <= 143)
    model.addConstr(9 * x1 + 4 * x3 <= 155)
    model.addConstr(12 * x0 + 4 * x3 <= 110)
    model.addConstr(12 * x0 + 9 * x1 + 11 * x2 + 4 * x3 <= 110)
    model.addConstr(4 * x1 + 6 * x2 <= 210)
    model.addConstr(6 * x2 + 13 * x3 <= 197)
    model.addConstr(9 * x0 + 4 * x1 + 6 * x2 <= 73)
    model.addConstr(9 * x0 + 4 * x1 + 6 * x2 + 13 * x3 <= 73)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Water purification units: {x0.varValue}")
        print(f"Pathfinder teams: {x1.varValue}")
        print(f"Light infantry companies: {x2.varValue}")
        print(f"Logistics companies: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
