
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0")  # hours worked by Bobby
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Laura

    # Set objective function
    m.setObjective(8.42*x0**2 + 1.43*x0*x1 + 9.94*x1**2 + 5.19*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16*x0 == 16, "c0")
    m.addConstr(1*x0 == 1, "c1")
    m.addConstr(24*x1 == 24, "c2")
    m.addConstr(21*x1 == 21, "c3")
    m.addConstr(16*x0 + 24*x1 >= 29, "c4")
    m.addConstr(1*x0 + 21*x1 >= 95, "c5")
    m.addConstr(-x0 + 7*x1 >= 0, "c6")
    m.addConstr(16*x0 + 24*x1 <= 35, "c7")
    m.addConstr(x0**2 + (21*x1)**2 <= 124, "c8")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
