
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Bobby", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Laura")

    # Objective function
    model.setObjective(8.42 * x1**2 + 1.43 * x1 * x2 + 9.94 * x2**2 + 5.19 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(16 * x1 + 24 * x2 >= 29)
    model.addConstr(1 * x1 + 21 * x2 >= 95)
    model.addConstr(-x1 + 7 * x2 >= 0)
    model.addConstr(16 * x1 + 24 * x2 <= 35)
    model.addConstr(x1**2 + x2**2 <= 124)
    model.addConstr(x1 <= 66/16)
    model.addConstr(x1 <= 218)
    model.addConstr(x2 <= 66/24)
    model.addConstr(x2 <= 218/21)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Bobby: ", x1.varValue)
        print("Hours worked by Laura: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
