
import gurobipy as gp

# Create a new model
m = gp.Model("supplement_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B12")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B4")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
x4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_C")


# Set objective function
m.setObjective(1*x0 + 5*x1 + 2*x2 + 8*x3 + 2*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.14*x0 + 2.31*x1 + 5.34*x2 + 4.55*x3 + 14.35*x4 <= 215, "muscle_growth_index")
m.addConstr(0.02*x0 + 15.78*x1 + 2.92*x2 + 1.15*x3 + 8.38*x4 <= 373, "digestive_support_index")
m.addConstr(7.07*x0 + 6.69*x1 + 15.2*x2 + 7.38*x3 + 13.55*x4 <= 155, "energy_stability_index")

# ... (rest of the constraints from the JSON "constraints" section)
# Example:
m.addConstr(2.31*x1 + 4.55*x3 >= 31, "c1")
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

