
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, name="x0")  # milligrams of vitamin B12
x1 = m.addVar(lb=0, name="x1")  # milligrams of vitamin B4
x2 = m.addVar(lb=0, name="x2")  # milligrams of zinc
x3 = m.addVar(lb=0, name="x3")  # milligrams of magnesium
x4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x4")  # milligrams of vitamin C

# Objective function
m.setObjective(x0 + 5 * x1 + 2 * x2 + 8 * x3 + 2 * x4, gp.GRB.MAXIMIZE)

# Constraints
# Muscle growth index
m.addConstr(0.14 * x0 + 2.31 * x1 + 5.34 * x2 + 4.55 * x3 + 14.35 * x4 <= 215)
m.addConstr(2.31 * x1 + 4.55 * x3 >= 31)
m.addConstr(4.55 * x3 + 14.35 * x4 >= 34)
m.addConstr(0.14 * x0 + 4.55 * x3 >= 42)
m.addConstr(2.31 * x1 + 14.35 * x4 >= 41)
m.addConstr(5.34 * x2 + 2.31 * x1 >= 28)
m.addConstr(0.14 * x0 + 5.34 * x2 >= 24)
m.addConstr(0.14 * x0 + 5.34 * x2 + 14.35 * x4 >= 43)
m.addConstr(5.34 * x2 + 4.55 * x3 + 14.35 * x4 >= 43)

# ... add all constraints similarly

# Digestive support index
m.addConstr(0.02 * x0 + 15.78 * x1 + 2.92 * x2 + 1.15 * x3 + 8.38 * x4 <= 373)
m.addConstr(2.92 * x2 + 8.38 * x4 >= 55)

# Energy stability index
m.addConstr(7.07 * x0 + 6.69 * x1 + 15.2 * x2 + 7.38 * x3 + 13.55 * x4 <= 155)

# Solve the model
m.optimize()

# Print the solution
print("Objective: ", gp.gurobi.Value(m.getObjective()))
for v in m.getVars():
    print(v.varName, ":", gp.gurobi.Value(v))
