
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
    vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
    calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")


    # Set objective function
    m.setObjective(6*vitamin_e + 3*vitamin_b6 + 8*vitamin_b2 + 1*calcium, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20*vitamin_b6 + 6*vitamin_b2 + 19*calcium >= 38, "c1")
    m.addConstr(9*vitamin_b2 + 4*calcium <= 333, "c2")
    m.addConstr(8*vitamin_e + 1*vitamin_b6 <= 262, "c3")
    m.addConstr(1*vitamin_b6 + 9*vitamin_b2 + 4*calcium <= 247, "c4")
    m.addConstr(8*vitamin_e + 1*vitamin_b6 + 9*vitamin_b2 <= 296, "c5")
    m.addConstr(8*vitamin_e + 9*vitamin_b2 + 4*calcium <= 363, "c6")
    m.addConstr(8*vitamin_e + 1*vitamin_b6 + 9*vitamin_b2 + 4*calcium <= 363, "c7")
    m.addConstr(6*vitamin_b2 + 19*calcium <= 292, "c8")
    m.addConstr(12*vitamin_e + 6*vitamin_b2 <= 198, "c9")
    m.addConstr(12*vitamin_e + 20*vitamin_b6 <= 226, "c10")
    m.addConstr(20*vitamin_b6 + 19*calcium <= 90, "c11")
    m.addConstr(12*vitamin_e + 6*vitamin_b2 + 19*calcium <= 302, "c12")
    m.addConstr(12*vitamin_e + 20*vitamin_b6 + 6*vitamin_b2 + 19*calcium <= 302, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
