
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-float('inf'), ub=float('inf'), name="milligrams of vitamin E")
    x1 = model.addVar(lb=-float('inf'), ub=float('inf'), name="milligrams of vitamin B6")
    x2 = model.addVar(lb=-float('inf'), ub=float('inf'), name="milligrams of vitamin B2")
    x3 = model.addVar(lb=-float('inf'), ub=float('inf'), name="milligrams of calcium")

    # Define the objective function
    model.setObjective(6*x0 + 3*x1 + 8*x2 + x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12*x0 + 20*x1 + 6*x2 + 19*x3 <= 303)
    model.addConstr(8*x0 + x1 + 9*x2 + 4*x3 <= 397)
    model.addConstr(20*x1 + 19*x3 >= 38)
    model.addConstr(9*x2 + 4*x3 <= 333)
    model.addConstr(8*x0 + x1 <= 262)
    model.addConstr(x1 + 9*x2 + 4*x3 <= 247)
    model.addConstr(8*x0 + x1 + 9*x2 <= 296)
    model.addConstr(8*x0 + 9*x2 + 4*x3 <= 363)
    model.addConstr(8*x0 + x1 + 9*x2 + 4*x3 <= 363)
    model.addConstr(6*x2 + 19*x3 <= 292)
    model.addConstr(12*x0 + 6*x2 <= 198)
    model.addConstr(12*x0 + 20*x1 <= 226)
    model.addConstr(20*x1 + 19*x3 <= 90)
    model.addConstr(12*x0 + 6*x2 + 19*x3 <= 302)
    model.addConstr(12*x0 + 20*x1 + 6*x2 + 19*x3 <= 302)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x0.varValue}")
        print(f"Milligrams of vitamin B6: {x1.varValue}")
        print(f"Milligrams of vitamin B2: {x2.varValue}")
        print(f"Milligrams of calcium: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
