
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b2")


# Set objective function
m.setObjective(4.91 * zinc + 6.7 * potassium + 8.7 * vitamin_c + 1.7 * vitamin_b2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * potassium + 9 * vitamin_b2 >= 37)
m.addConstr(6 * potassium + 4 * vitamin_c >= 45)
m.addConstr(4 * vitamin_c + 9 * vitamin_b2 >= 39)
m.addConstr(4 * zinc + 4 * vitamin_c >= 24)
m.addConstr(4 * zinc + 6 * potassium >= 39)
m.addConstr(6 * potassium + 4 * vitamin_c + 9 * vitamin_b2 >= 27)
m.addConstr(4 * zinc + 6 * potassium + 4 * vitamin_c >= 27)
m.addConstr(4 * zinc + 4 * vitamin_c + 9 * vitamin_b2 >= 27)
m.addConstr(6 * potassium + 4 * vitamin_c + 9 * vitamin_b2 >= 23)
m.addConstr(4 * zinc + 6 * potassium + 4 * vitamin_c >= 23)
m.addConstr(4 * zinc + 4 * vitamin_c + 9 * vitamin_b2 >= 23)
m.addConstr(6 * potassium + 4 * vitamin_c + 9 * vitamin_b2 >= 26)
m.addConstr(4 * zinc + 6 * potassium + 4 * vitamin_c >= 26)
m.addConstr(4 * zinc + 4 * vitamin_c + 9 * vitamin_b2 >= 26)
m.addConstr(4 * zinc + 6 * potassium + 4 * vitamin_c + 9 * vitamin_b2 >= 26)
m.addConstr(10 * vitamin_c + 7 * vitamin_b2 >= 53)
m.addConstr(16 * potassium + 7 * vitamin_b2 >= 48)
m.addConstr(20 * zinc + 16 * potassium >= 27)
m.addConstr(20 * zinc + 16 * potassium + 10 * vitamin_c + 7 * vitamin_b2 >= 27)
m.addConstr(6 * vitamin_c - 9 * vitamin_b2 >= 0)
m.addConstr(6 * zinc - 4 * potassium >= 0)
m.addConstr(8 * zinc - 10 * vitamin_c >= 0)
m.addConstr(4 * zinc + 6 * potassium <= 174)
m.addConstr(20 * zinc + 16 * potassium + 10 * vitamin_c <= 90)
m.addConstr(20 * zinc + 16 * potassium + 7 * vitamin_b2 <= 236)

# Resource Constraints
m.addConstr(4 * zinc + 6 * potassium + 4 * vitamin_c + 9 * vitamin_b2 <= 181) # Kidney support
m.addConstr(20 * zinc + 16 * potassium + 10 * vitamin_c + 7 * vitamin_b2 <= 248) # Energy stability


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('zinc:', zinc.x)
    print('potassium:', potassium.x)
    print('vitamin_c:', vitamin_c.x)
    print('vitamin_b2:', vitamin_b2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

