
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of zinc
    x1 = model.addVar(name="x1", lb=0)  # milligrams of potassium
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin C
    x3 = model.addVar(name="x3", lb=0, type=gurobi.GRB.INTEGER)  # milligrams of vitamin B2

    # Objective function
    model.setObjective(4.91*x0 + 6.7*x1 + 8.7*x2 + 1.7*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6*x1 + 9*x3 >= 37)
    model.addConstr(6*x1 + 4*x2 >= 45)
    model.addConstr(4*x2 + 9*x3 >= 39)
    model.addConstr(4*x0 + 4*x2 >= 24)
    model.addConstr(4*x0 + 6*x1 >= 39)
    model.addConstr(6*x1 + 4*x2 + 9*x3 >= 27)
    model.addConstr(4*x0 + 4*x2 + 6*x1 >= 27)
    model.addConstr(4*x0 + 4*x2 + 9*x3 >= 27)
    model.addConstr(6*x1 + 4*x2 + 9*x3 >= 23)
    model.addConstr(4*x0 + 6*x1 + 4*x2 >= 23)
    model.addConstr(4*x0 + 4*x2 + 9*x3 >= 23)
    model.addConstr(6*x1 + 4*x2 + 9*x3 >= 26)
    model.addConstr(4*x0 + 6*x1 + 4*x2 >= 26)
    model.addConstr(4*x0 + 4*x2 + 9*x3 >= 26)
    model.addConstr(4*x0 + 6*x1 + 4*x2 + 9*x3 >= 26)
    model.addConstr(10*x2 + 7*x3 >= 53)
    model.addConstr(16*x1 + 7*x3 >= 48)
    model.addConstr(20*x0 + 16*x1 >= 27)
    model.addConstr(20*x0 + 16*x1 + 10*x2 + 7*x3 >= 27)
    model.addConstr(6*x2 - 9*x3 >= 0)
    model.addConstr(6*x0 - 4*x1 >= 0)
    model.addConstr(8*x0 - 10*x2 >= 0)
    model.addConstr(4*x0 + 6*x1 <= 174)
    model.addConstr(20*x0 + 16*x1 + 10*x2 <= 90)
    model.addConstr(20*x0 + 16*x1 + 7*x3 <= 236)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0 (milligrams of zinc): ", x0.varValue)
        print("x1 (milligrams of potassium): ", x1.varValue)
        print("x2 (milligrams of vitamin C): ", x2.varValue)
        print("x3 (milligrams of vitamin B2): ", x3.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
