
import gurobipy as gp

# Create a new model
m = gp.Model("employee_scheduling")

# Create variables
laura_hours = m.addVar(lb=0, name="laura_hours")
peggy_hours = m.addVar(lb=0, name="peggy_hours")
mary_hours = m.addVar(lb=0, name="mary_hours")
jean_hours = m.addVar(lb=0, name="jean_hours")


# Set objective function
m.setObjective(7 * laura_hours + 7 * peggy_hours + 2 * mary_hours + 2 * jean_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * peggy_hours + 16 * mary_hours >= 39)
m.addConstr(2 * peggy_hours + 7 * jean_hours >= 41)
m.addConstr(12 * laura_hours + 16 * mary_hours >= 58)
m.addConstr(2 * peggy_hours + 16 * mary_hours + 7 * jean_hours >= 48)
m.addConstr(12 * laura_hours + 2 * peggy_hours + 7 * jean_hours >= 48)
m.addConstr(12 * laura_hours + 16 * mary_hours + 7 * jean_hours >= 48)
m.addConstr(2 * peggy_hours + 16 * mary_hours + 7 * jean_hours >= 71)
m.addConstr(12 * laura_hours + 2 * peggy_hours + 7 * jean_hours >= 71)
m.addConstr(12 * laura_hours + 16 * mary_hours + 7 * jean_hours >= 71)
m.addConstr(2 * peggy_hours + 16 * mary_hours + 7 * jean_hours >= 59)
m.addConstr(12 * laura_hours + 2 * peggy_hours + 7 * jean_hours >= 59)
m.addConstr(12 * laura_hours + 16 * mary_hours + 7 * jean_hours >= 59)

# ... (rest of the constraints -  add all constraints similarly as above)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Laura hours:', laura_hours.x)
    print('Peggy hours:', peggy_hours.x)
    print('Mary hours:', mary_hours.x)
    print('Jean hours:', jean_hours.x)

elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status:', m.status)

