
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="oreos")
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strips_of_bacon")


# Set objective function
m.setObjective(7*x0 + 5*x1 + 4*x2 + 6*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 3*x1 + 3*x2 + 6*x3 <= 244, "dollar_cost")
m.addConstr(7*x0 + 7*x1 + 11*x2 + 11*x3 <= 341, "calcium")
m.addConstr(3*x0 + 11*x1 + 3*x2 + 13*x3 <= 301, "umami")
m.addConstr(3*x2 + 6*x3 >= 60, "oreos_bacon_cost")
m.addConstr(2*x0 + 3*x2 >= 23, "chicken_oreo_cost")
m.addConstr(2*x0 + 3*x1 + 3*x2 + 6*x3 >= 23, "total_cost_min")
m.addConstr(7*x0 + 11*x3 >= 77, "calcium_chicken_bacon")
m.addConstr(7*x0 + 11*x2 >= 47, "calcium_chicken_oreos")
m.addConstr(7*x1 + 11*x2 >= 71, "calcium_strawberries_oreos")
m.addConstr(11*x2 + 11*x3 >= 82, "calcium_oreos_bacon")
m.addConstr(7*x1 + 11*x3 >= 75, "calcium_strawberries_bacon")
m.addConstr(7*x0 + 11*x2 + 11*x3 >= 79, "calcium_chicken_oreos_bacon")
m.addConstr(7*x0 + 7*x1 + 11*x3 >= 79, "calcium_chicken_strawberries_bacon")
m.addConstr(7*x0 + 11*x2 + 11*x3 >= 80, "calcium_chicken_oreos_bacon2")
m.addConstr(7*x0 + 7*x1 + 11*x3 >= 80, "calcium_chicken_strawberries_bacon2")
m.addConstr(7*x0 + 7*x1 + 11*x2 + 11*x3 >= 80, "calcium_all")
m.addConstr(3*x0 + 3*x2 >= 37, "umami_chicken_oreos")
m.addConstr(11*x1 + 3*x2 >= 72, "umami_strawberries_oreos")
m.addConstr(3*x0 + 3*x2 + 13*x3 >= 69, "umami_chicken_oreos_bacon")
m.addConstr(11*x1 + 3*x2 + 13*x3 >= 69, "umami_strawberries_oreos_bacon")
m.addConstr(3*x0 + 3*x2 + 13*x3 >= 49, "umami_chicken_oreos_bacon2")
m.addConstr(11*x1 + 3*x2 + 13*x3 >= 49, "umami_strawberries_oreos_bacon2")
m.addConstr(3*x0 + 11*x1 + 3*x2 + 13*x3 >= 49, "umami_all")
m.addConstr(10*x1 - 6*x2 >= 0, "strawberries_oreos_relation")
m.addConstr(7*x0 - x3 >= 0, "chicken_bacon_relation")
m.addConstr(3*x1 + 3*x2 <= 196, "cost_strawberries_oreos_max")
m.addConstr(2*x0 + 6*x3 <= 221, "cost_chicken_bacon_max")
m.addConstr(3*x1 + 6*x3 <= 100, "cost_strawberries_bacon_max")
m.addConstr(2*x0 + 3*x1 <= 183, "cost_chicken_strawberries_max")
m.addConstr(3*x1 + 3*x2 + 6*x3 <= 124, "cost_strawberries_oreos_bacon_max")
m.addConstr(2*x0 + 3*x2 + 6*x3 <= 179, "cost_chicken_oreos_bacon_max")
m.addConstr(11*x2 + 11*x3 <= 288, "calcium_oreos_bacon_max")
m.addConstr(7*x0 + 7*x1 <= 278, "calcium_chicken_strawberries_max")
m.addConstr(3*x0 + 13*x3 <= 139, "umami_chicken_bacon_max")
m.addConstr(3*x0 + 3*x2 <= 148, "umami_chicken_oreos_max")
m.addConstr(3*x0 + 3*x2 + 13*x3 <= 77, "umami_chicken_oreos_bacon_max")
m.addConstr(3*x0 + 11*x1 + 13*x3 <= 115, "umami_chicken_strawberries_bacon_max")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

