
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # rotisserie chickens
x1 = m.addVar(name="x1", lb=0)  # strawberries
x2 = m.addVar(name="x2", lb=0, integrality=gurobi.GRB.INTEGER)  # oreos
x3 = m.addVar(name="x3", lb=0)  # strips of bacon

# Objective function
m.setObjective(7 * x0 + 5 * x1 + 4 * x2 + 6 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(2 * x0 + 3 * x1 + 3 * x2 + 6 * x3 <= 244)
m.addConstr(7 * x0 + 7 * x1 + 11 * x2 + 11 * x3 <= 341)
m.addConstr(3 * x0 + 11 * x1 + 3 * x2 + 13 * x3 <= 301)
m.addConstr(3 * x2 + 6 * x3 >= 60)
m.addConstr(2 * x0 + 3 * x2 >= 23)
m.addConstr(2 * x0 + 3 * x1 + 3 * x2 + 6 * x3 >= 23)
m.addConstr(7 * x0 + 11 * x3 >= 77)
m.addConstr(7 * x0 + 11 * x2 >= 47)
m.addConstr(7 * x1 + 11 * x2 >= 71)
m.addConstr(11 * x2 + 11 * x3 >= 82)
m.addConstr(7 * x1 + 11 * x3 >= 75)
m.addConstr(7 * x0 + 11 * x2 + 11 * x3 >= 79)
m.addConstr(7 * x0 + 7 * x1 + 11 * x3 >= 79)
m.addConstr(7 * x0 + 11 * x2 + 11 * x3 >= 80)
m.addConstr(7 * x0 + 7 * x1 + 11 * x3 >= 80)
m.addConstr(7 * x0 + 7 * x1 + 11 * x2 + 11 * x3 >= 80)
m.addConstr(3 * x0 + 3 * x2 >= 37)
m.addConstr(11 * x1 + 3 * x2 >= 72)
m.addConstr(3 * x0 + 3 * x2 + 13 * x3 >= 69)
m.addConstr(11 * x1 + 3 * x2 + 13 * x3 >= 69)
m.addConstr(3 * x0 + 13 * x3 >= 49)
m.addConstr(11 * x1 + 13 * x3 >= 49)
m.addConstr(3 * x0 + 3 * x2 + 13 * x3 >= 49)
m.addConstr(10 * x1 - 6 * x2 >= 0)
m.addConstr(7 * x0 - x3 >= 0)
m.addConstr(3 * x1 + 3 * x2 <= 196)
m.addConstr(2 * x0 + 6 * x3 <= 221)
m.addConstr(3 * x1 + 6 * x3 <= 100)
m.addConstr(2 * x0 + 3 * x1 <= 183)
m.addConstr(3 * x1 + 3 * x2 + 6 * x3 <= 124)
m.addConstr(2 * x0 + 3 * x2 + 6 * x3 <= 179)
m.addConstr(11 * x2 + 11 * x3 <= 288)
m.addConstr(7 * x0 + 7 * x1 <= 278)
m.addConstr(3 * x0 + 13 * x3 <= 139)
m.addConstr(3 * x0 + 3 * x2 <= 148)
m.addConstr(3 * x0 + 3 * x2 + 13 * x3 <= 77)
m.addConstr(3 * x0 + 11 * x1 + 13 * x3 <= 115)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
