
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")
    x4 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x4")


    # Set objective function
    model.setObjective(5.99*x0 + 7.61*x1 + 6.69*x2 + 4.64*x3 + 6.21*x4, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18*x0 + 11*x2 + 6*x4 >= 54)
    model.addConstr(18*x0 + 9*x1 + 6*x4 >= 54)
    model.addConstr(11*x2 + 11*x3 + 6*x4 >= 54)
    model.addConstr(18*x0 + 11*x2 + 6*x4 >= 37)
    model.addConstr(18*x0 + 9*x1 + 6*x4 >= 37)
    model.addConstr(11*x2 + 11*x3 + 6*x4 >= 37)
    model.addConstr(18*x0 + 11*x2 + 6*x4 >= 39)
    model.addConstr(18*x0 + 9*x1 + 6*x4 >= 39)
    model.addConstr(11*x2 + 11*x3 + 6*x4 >= 39)
    model.addConstr(-4*x0 + x3 >= 0)
    model.addConstr(18*x0 + 9*x1 <= 240)
    model.addConstr(11*x2 + 6*x4 <= 201)
    model.addConstr(9*x1 + 11*x3 <= 170)
    model.addConstr(9*x1 + 6*x4 <= 138)
    model.addConstr(18*x0 + 11*x3 <= 184)
    model.addConstr(9*x1 + 11*x2 + 6*x4 <= 213)
    model.addConstr(18*x0 + 11*x2 + 11*x3 <= 208)
    model.addConstr(11*x2 + 11*x3 + 6*x4 <= 113)
    model.addConstr(18*x0 + 9*x1 + 11*x2 + 11*x3 + 6*x4 <= 272)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
