
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Bobby
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Peggy
    x3 = model.addVar(name='x3', lb=0)  # hours worked by Dale
    x4 = model.addVar(name='x4', lb=0)  # hours worked by Paul
    x5 = model.addVar(name='x5', lb=0)  # hours worked by Mary

    # Define the objective function
    model.setObjective(5.99 * x1 + 7.61 * x2 + 6.69 * x3 + 4.64 * x4 + 6.21 * x5, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18 * x1 + 11 * x3 + 6 * x5 >= 54)
    model.addConstr(18 * x1 + 9 * x2 + 6 * x5 >= 54)
    model.addConstr(11 * x3 + 11 * x4 + 6 * x5 >= 54)
    model.addConstr(18 * x1 + 11 * x3 + 6 * x5 >= 37)
    model.addConstr(18 * x1 + 9 * x2 + 6 * x5 >= 37)
    model.addConstr(11 * x3 + 11 * x4 + 6 * x5 >= 37)
    model.addConstr(18 * x1 + 11 * x3 + 6 * x5 >= 39)
    model.addConstr(18 * x1 + 9 * x2 + 6 * x5 >= 39)
    model.addConstr(11 * x3 + 11 * x4 + 6 * x5 >= 39)
    model.addConstr(-4 * x1 + x4 >= 0)
    model.addConstr(18 * x1 + 9 * x2 <= 240)
    model.addConstr(11 * x3 + 6 * x5 <= 201)
    model.addConstr(9 * x2 + 11 * x4 <= 170)
    model.addConstr(9 * x2 + 6 * x5 <= 138)
    model.addConstr(18 * x1 + 11 * x4 <= 184)
    model.addConstr(9 * x2 + 11 * x3 + 6 * x5 <= 213)
    model.addConstr(18 * x1 + 11 * x3 + 11 * x4 <= 208)
    model.addConstr(11 * x3 + 11 * x4 + 6 * x5 <= 113)
    model.addConstr(18 * x1 + 9 * x2 + 11 * x3 + 11 * x4 + 6 * x5 <= 113)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by Bobby: ', x1.varValue)
        print('Hours worked by Peggy: ', x2.varValue)
        print('Hours worked by Dale: ', x3.varValue)
        print('Hours worked by Paul: ', x4.varValue)
        print('Hours worked by Mary: ', x5.varValue)
    else:
        print('No optimal solution found')

optimize_problem()
