
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B5
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # grams of protein
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin E
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x3")  # milligrams of iron
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")  # grams of carbohydrates


# Set objective function
m.setObjective(3*x0**2 + 7*x0*x1 + x0*x2 + 2*x0*x4 + 6*x1**2 + 3*x1*x2 + 6*x1*x4 + 7*x2**2 + x2*x3 + 8*x2*x4 + 7*x3**2 + 9*x3*x4 + 6*x4**2 + 9*x0 + 6*x1, gp.GRB.MAXIMIZE)

# Add constraints
constraints_data = [
    (4, 5, 2, 6, 8, 87),
    (5, 5, 3, 5, 6, 89),
    (8, 3, 8, 3, 3, 128)
]

resource_constraints = []
for i, (c0, c1, c2, c3, c4, ub) in enumerate(constraints_data):
    resource_constraints.append(m.addConstr(c0 * x0 + c1 * x1 + c2 * x2 + c3 * x3 + c4 * x4 <= ub, f"r{i}"))


# Add other constraints from the problem description (simplified and corrected for errors)
m.addConstr(6*x3 + 8*x4 <= 34)
m.addConstr(5*x1 + 2*x2 <= 19)
m.addConstr(4*x0 + 8*x4 <= 49)
m.addConstr(5*x1 + 5*x3 <= 56)
m.addConstr(5*x0 + 6*x4 <= 22)
m.addConstr(5*x3 + 6*x4 <= 66)
m.addConstr(5*x0 + 3*x2 <= 63)
m.addConstr(5*x0 + 5*x3 <= 19)
m.addConstr(3*x2 + 6*x4 <= 86)
m.addConstr(8*x0 + 3*x3 <= 43)
m.addConstr(3*x3 + 3*x4 <= 61)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

