
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='blue highlighters', vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name='3D printers', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='lanyards', vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name='hole punches', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(1.75*x0 + 9.74*x1 + 8.21*x2 + 2.83*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(26*x0 + 32*x1 + 24*x2 + 7*x3 <= 445)
model.addConstr(x0 + 18*x1 + 22*x2 + 22*x3 <= 445)
model.addConstr(x0 + x3 >= 97/26)
model.addConstr(32*x1 + 7*x3 >= 94)
model.addConstr(24*x2 + 7*x3 >= 45)
model.addConstr(26*x0 + 24*x2 >= 49)
model.addConstr(x0 + 22*x3 >= 64)
model.addConstr(x0 + 22*x2 >= 37)
model.addConstr(x0 + 18*x1 + 22*x2 >= 87)
model.addConstr(18*x1 + 22*x2 + 22*x3 >= 87)
model.addConstr(x0 + 18*x1 + 22*x2 >= 55)
model.addConstr(18*x1 + 22*x2 + 22*x3 >= 55)
model.addConstr(-9*x0 + 10*x1 >= 0)
model.addConstr(26*x0 + 32*x1 <= 336)
model.addConstr(24*x2 + 7*x3 <= 433)
model.addConstr(26*x0 + 24*x2 + 7*x3 <= 398)
model.addConstr(26*x0 + 32*x1 + 7*x3 <= 350)
model.addConstr(32*x1 + 24*x2 + 7*x3 <= 279)
model.addConstr(26*x0 + 32*x1 + 24*x2 + 7*x3 <= 279)
model.addConstr(22*x2 + 22*x3 <= 291)
model.addConstr(x0 + 22*x3 <= 414)
model.addConstr(x0 + 18*x1 <= 291)
model.addConstr(x0 + 22*x2 <= 277)
model.addConstr(x0 + 18*x1 + 22*x2 <= 147)
model.addConstr(18*x1 + 22*x2 + 22*x3 <= 282)
model.addConstr(x0 + 18*x1 + 22*x2 + 22*x3 <= 282)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('blue highlighters: ', x0.varValue)
    print('3D printers: ', x1.varValue)
    print('lanyards: ', x2.varValue)
    print('hole punches: ', x3.varValue)
else:
    print('The model is infeasible')
