
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_resource_allocation")

    # Create variables
    intrusion_analysts = model.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
    automatic_alerts = model.addVar(vtype=GRB.INTEGER, name="automatic_alerts")


    # Set objective function
    model.setObjective(4*intrusion_analysts**2 + intrusion_analysts*automatic_alerts + 6*automatic_alerts**2 + 2*intrusion_analysts + 7*automatic_alerts, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(9*intrusion_analysts + 14*automatic_alerts <= 31, "Network Latency Constraint")
    model.addConstr(12*intrusion_analysts + 6*automatic_alerts <= 41, "Bandwidth Constraint")
    model.addConstr(intrusion_analysts**2 + automatic_alerts**2 >= 14, "Squared Latency Constraint")
    model.addConstr(12*intrusion_analysts + 6*automatic_alerts >= 9, "Min Bandwidth Constraint")
    model.addConstr(-2*intrusion_analysts + 10*automatic_alerts >= 0, "Analyst Alert Ratio Constraint")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Intrusion Analysts: {intrusion_analysts.x}")
        print(f"Automatic Alerts: {automatic_alerts.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
