
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
x1 = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")

# Objective function: Maximize
m.setObjective(4*x0**2 + x0*x1 + 6*x1**2 + 2*x0 + 7*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(9*x0 + 14*x1 <= 31, name="max_network_latency")
m.addConstr(12*x0 + 6*x1 >= 9, name="min_bandwidth_usage")
m.addConstr((9*x0)**2 + (14*x1)**2 >= 196, name="min_network_latency_squared")
m.addConstr(-2*x0 + 10*x1 >= 0, name="analysts_vs_alerts")
m.addConstr((12*x0)**2 + (6*x1)**2 <= 1681, name="max_bandwidth_usage_squared")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Intrusion Analysts: {x0.x}")
    print(f"Automatic Alerts: {x1.x}")
else:
    print("No optimal solution found.")
