
import gurobipy as gp

# Create a new model
m = gp.Model("intrusion_analysts_automatic_alerts")

# Define variables
x1 = m.addVar(name="intrusion_analysts", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="automatic_alerts", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(4*x1**2 + x1*x2 + 6*x2**2 + 2*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(9*x1 + 14*x2 <= 37, name="network_latency")
m.addConstr(12*x1 + 6*x2 <= 56, name="available_bandwidth")
m.addConstr(x1**2 + x2**2 >= 14, name="network_latency_squared")
m.addConstr(x1 + x2 >= 9, name="bandwidth_usage")
m.addConstr(-2*x1 + 10*x2 >= 0, name="analysts_alerts_relationship")
m.addConstr(9*x1 + 14*x2 <= 31, name="network_latency_limit")
m.addConstr(x1**2 + x2**2 <= 41, name="bandwidth_squared_limit")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Intrusion Analysts: {x1.varValue}")
    print(f"Automatic Alerts: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
