
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")


# Set objective function
m.setObjective(2.15 * vitamin_b12 + 7.39 * vitamin_b4 + 8.41 * calcium + 8.03 * magnesium + 5.47 * zinc + 7.42 * vitamin_e + 8.13 * vitamin_c, gp.GRB.MAXIMIZE)

# Add constraints based on provided resources/attributes
cognitive_performance_index = 12 * vitamin_b12 + 5 * vitamin_b4 + 6 * calcium + 11 * magnesium + 6 * zinc + 9 * vitamin_e + 1 * vitamin_c
energy_stability_index = 13 * vitamin_b12 + 3 * vitamin_b4 + 3 * calcium + 11 * magnesium + 6 * zinc + 11 * vitamin_e + 4 * vitamin_c
digestive_support_index = 1 * vitamin_b12 + 9 * vitamin_b4 + 1 * calcium + 12 * magnesium + 11 * zinc + 1 * vitamin_e + 10 * vitamin_c


m.addConstr(cognitive_performance_index <= 146)
m.addConstr(energy_stability_index <= 170)
m.addConstr(digestive_support_index <= 183)


# Add other constraints as provided in the input
m.addConstr(12 * vitamin_b12 + 1 * vitamin_c >= 15)
m.addConstr(9 * vitamin_e + 1 * vitamin_c >= 12)
m.addConstr(6 * calcium + 6 * zinc >= 9)
# ... (add all remaining constraints similarly)
m.addConstr(11 * magnesium + 6 * zinc <= 76)
m.addConstr(13 * vitamin_b12 + 3 * vitamin_b4 >= 18)
m.addConstr(6 * zinc + 4 * vitamin_c >= 15)
# ... (add all remaining constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

