
from gurobipy import *

# Create a new model
m = Model("Nutrient_Optimization")

# Define variables
x1 = m.addVar(name="vitamin_B12", lb=0)
x2 = m.addVar(name="vitamin_B4", lb=0)
x3 = m.addVar(name="calcium", lb=0)
x4 = m.addVar(name="magnesium", lb=0)
x5 = m.addVar(name="zinc", lb=0)
x6 = m.addVar(name="vitamin_E", lb=0)
x7 = m.addVar(name="vitamin_C", lb=0)

# Set the objective function
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x5 <= 152)
# Add other constraints here

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vitamin B12: {x1.x}")
    print(f"Vitamin B4: {x2.x}")
    print(f"Calcium: {x3.x}")
    print(f"Magnesium: {x4.x}")
    print(f"Zinc: {x5.x}")
    print(f"Vitamin E: {x6.x}")
    print(f"Vitamin C: {x7.x}")
else:
    print("No optimal solution found")
