
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")

# Set objective function
m.setObjective(9.24 * bagged_salads + 9.78 * chicken_breasts + 9.68 * strawberries + 3.69 * kale_salads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * bagged_salads + 17 * kale_salads >= 26, "c1")
m.addConstr(14 * chicken_breasts + 17 * kale_salads >= 53, "c2")
m.addConstr(9 * bagged_salads + 14 * chicken_breasts + 19 * strawberries + 17 * kale_salads >= 53, "c3")
m.addConstr(10 * bagged_salads - 4 * chicken_breasts >= 0, "c4")
m.addConstr(14 * chicken_breasts + 19 * strawberries <= 221, "c5")
m.addConstr(9 * bagged_salads + 17 * kale_salads <= 117, "c6")
m.addConstr(9 * bagged_salads + 14 * chicken_breasts <= 106, "c7")
m.addConstr(19 * strawberries + 17 * kale_salads <= 204, "c8")
m.addConstr(9 * bagged_salads + 14 * chicken_breasts + 19 * strawberries + 17 * kale_salads <= 225, "c9")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bagged_salads:', bagged_salads.x)
    print('chicken_breasts:', chicken_breasts.x)
    print('strawberries:', strawberries.x)
    print('kale_salads:', kale_salads.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

