
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale_salads")

# Define the objective function
m.setObjective(9.24*x1 + 9.78*x2 + 9.68*x3 + 3.69*x4, GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x1 + 17*x4 >= 26, name="constraint_1")
m.addConstr(14*x2 + 17*x4 >= 53, name="constraint_2")
m.addConstr(9*x1 + 14*x2 + 19*x3 + 17*x4 >= 53, name="constraint_3")
m.addConstr(10*x1 - 4*x2 >= 0, name="constraint_4")
m.addConstr(14*x2 + 19*x3 <= 221, name="constraint_5")
m.addConstr(9*x1 + 17*x4 <= 117, name="constraint_6")
m.addConstr(9*x1 + 14*x2 <= 106, name="constraint_7")
m.addConstr(19*x3 + 17*x4 <= 204, name="constraint_8")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found.")

