
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="bagged_salads", lb=0)  # bagged salads
    x1 = model.addVar(name="chicken_breasts", lb=0)  # chicken breasts
    x2 = model.addVar(name="strawberries", lb=0)  # strawberries
    x3 = model.addVar(name="kale_salads", lb=0)  # kale salads

    # Objective function
    model.setObjective(9.24*x0 + 9.78*x1 + 9.68*x2 + 3.69*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x0 + 14*x1 + 19*x2 + 17*x3 <= 225)  # total carbohydrates
    model.addConstr(9*x0 + 17*x3 >= 26)  # carbohydrates from bagged salads and kale salads
    model.addConstr(14*x1 + 17*x3 >= 53)  # carbohydrates from chicken breasts and kale salads
    model.addConstr(9*x0 + 14*x1 + 19*x2 + 17*x3 >= 53)  # total carbohydrates from all sources
    model.addConstr(10*x0 - 4*x1 >= 0)  # relationship between bagged salads and chicken breasts
    model.addConstr(14*x1 + 19*x2 <= 221)  # carbohydrates from chicken breasts and strawberries
    model.addConstr(9*x0 + 17*x3 <= 117)  # carbohydrates from bagged salads and kale salads
    model.addConstr(9*x0 + 14*x1 <= 106)  # carbohydrates from bagged salads and chicken breasts
    model.addConstr(19*x2 + 17*x3 <= 204)  # carbohydrates from strawberries and kale salads

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("bagged salads: ", x0.varValue)
        print("chicken breasts: ", x1.varValue)
        print("strawberries: ", x2.varValue)
        print("kale salads: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
