
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
pizza_slices = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pizza_slices")
rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")


# Set objective function
m.setObjective(1.43*bananas**2 + 4.61*bananas*rotisserie_chickens + 8.91*protein_bars**2 + 2.92*apples*pizza_slices + 7.21*pizza_slices**2 + 4.78*pizza_slices*rotisserie_chickens + 8.11*rotisserie_chickens**2 + 9.07*bananas + 3.59*apples, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*protein_bars**2 + 2*apples**2 + 5*rotisserie_chickens**2 >= 31)
m.addConstr(3*bananas**2 + 3*protein_bars**2 + 2*apples**2 >= 31)
m.addConstr(3*protein_bars**2 + 2*apples**2 + 10*pizza_slices**2 >= 31)
m.addConstr(3*protein_bars**2 + 2*apples**2 + 5*rotisserie_chickens**2 >= 27)
m.addConstr(3*bananas**2 + 3*protein_bars**2 + 2*apples**2 >= 27)
m.addConstr(3*protein_bars + 2*apples + 10*pizza_slices >= 27)
m.addConstr(3*protein_bars + 2*apples + 5*rotisserie_chickens >= 39)
m.addConstr(3*bananas**2 + 3*protein_bars**2 + 2*apples**2 >= 39)
m.addConstr(3*protein_bars**2 + 2*apples**2 + 10*pizza_slices**2 >= 39)
m.addConstr(8*bananas**2 + 7*protein_bars**2 + 6*apples**2 >= 31)
m.addConstr(8*bananas**2 + 7*protein_bars**2 + 8*rotisserie_chickens**2 >= 31)
m.addConstr(8*bananas + 7*protein_bars + 3*pizza_slices >= 31)
m.addConstr(7*protein_bars**2 + 3*pizza_slices**2 + 8*rotisserie_chickens**2 >= 31)
m.addConstr(8*bananas + 6*apples + 8*rotisserie_chickens >= 31)
# ... (rest of the constraints - see full code in the attached file)


m.addConstr(3*bananas <= 218)
m.addConstr(8*bananas <= 187)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

