
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("plant_optimization")

    # Create variables
    lilies = m.addVar(vtype=gp.GRB.INTEGER, name="lilies")
    boxwoods = m.addVar(vtype=gp.GRB.INTEGER, name="boxwoods")
    vincas = m.addVar(vtype=gp.GRB.INTEGER, name="vincas")
    chili_plants = m.addVar(vtype=gp.GRB.INTEGER, name="chili_plants")
    roses = m.addVar(vtype=gp.GRB.INTEGER, name="roses")

    # Set objective function
    m.setObjective(1.84 * lilies + 5.88 * boxwoods + 5.84 * vincas + 1.97 * chili_plants + 6.9 * roses, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(12 * vincas + 10 * roses >= 26)
    m.addConstr(2 * lilies + 12 * vincas >= 11)
    m.addConstr(2 * lilies + 13 * boxwoods >= 17)
    m.addConstr(13 * boxwoods + 14 * chili_plants >= 30)
    m.addConstr(12 * vincas + 14 * chili_plants >= 29)
    m.addConstr(13 * boxwoods + 12 * vincas >= 15)
    m.addConstr(13 * boxwoods + 12 * vincas + 14 * chili_plants >= 21)
    m.addConstr(2 * lilies + 13 * boxwoods + 12 * vincas + 14 * chili_plants + 10 * roses >= 21)
    m.addConstr(boxwoods - 4 * chili_plants >= 0)
    m.addConstr(2 * vincas - 10 * roses >= 0)
    m.addConstr(2 * lilies + 13 * boxwoods <= 117)
    m.addConstr(13 * boxwoods + 10 * roses <= 110)
    m.addConstr(2 * lilies + 12 * vincas + 10 * roses <= 70)
    m.addConstr(13 * boxwoods + 12 * vincas + 10 * roses <= 90)
    m.addConstr(2 * lilies + 12 * vincas + 14 * chili_plants <= 136)
    m.addConstr(2 * lilies + 13 * boxwoods + 10 * roses <= 36)
    m.addConstr(12 * vincas + 14 * chili_plants + 10 * roses <= 44)
    m.addConstr(2 * lilies + 13 * boxwoods + 14 * chili_plants <= 149)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
