
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    lilies = model.addVar(name="lilies", vtype=gurobi.GRB.INTEGER)
    boxwoods = model.addVar(name="boxwoods", vtype=gurobi.GRB.INTEGER)
    vincas = model.addVar(name="vincas", vtype=gurobi.GRB.INTEGER)
    chili_plants = model.addVar(name="chili_plants", vtype=gurobi.GRB.INTEGER)
    roses = model.addVar(name="roses", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(1.84 * lilies + 5.88 * boxwoods + 5.84 * vincas + 1.97 * chili_plants + 6.9 * roses, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12 * vincas + 10 * roses >= 26)
    model.addConstr(2 * lilies + 12 * vincas >= 11)
    model.addConstr(2 * lilies + 13 * boxwoods >= 17)
    model.addConstr(13 * boxwoods + 14 * chili_plants >= 30)
    model.addConstr(12 * vincas + 14 * chili_plants >= 29)
    model.addConstr(13 * boxwoods + 12 * vincas >= 15)
    model.addConstr(13 * boxwoods + 12 * vincas + 14 * chili_plants >= 21)
    model.addConstr(2 * lilies + 13 * boxwoods + 12 * vincas + 14 * chili_plants + 10 * roses >= 21)
    model.addConstr(boxwoods - 4 * chili_plants >= 0)
    model.addConstr(2 * vincas - 10 * roses >= 0)
    model.addConstr(2 * lilies + 13 * boxwoods <= 117)
    model.addConstr(13 * boxwoods + 10 * roses <= 110)
    model.addConstr(2 * lilies + 12 * vincas + 10 * roses <= 70)
    model.addConstr(13 * boxwoods + 12 * vincas + 10 * roses <= 90)
    model.addConstr(2 * lilies + 12 * vincas + 14 * chili_plants <= 136)
    model.addConstr(2 * lilies + 13 * boxwoods + 10 * roses <= 36)
    model.addConstr(12 * vincas + 14 * chili_plants + 10 * roses <= 44)
    model.addConstr(2 * lilies + 13 * boxwoods + 14 * chili_plants <= 149)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Lilies: ", lilies.varValue)
        print("Boxwoods: ", boxwoods.varValue)
        print("Vincas: ", vincas.varValue)
        print("Chili Plants: ", chili_plants.varValue)
        print("Roses: ", roses.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
