
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
x = {}
item_names = ['rotisserie chickens', 'bananas', 'bowls of instant ramen', 'bowls of pasta', 'strips of bacon', 'ham sandwiches']
for i in range(len(item_names)):
    x[i] = m.addVar(vtype=GRB.CONTINUOUS, name=item_names[i])


# Set objective function
m.setObjective(1*x[0] + 1*x[1] + 9*x[2] + 6*x[3] + 7*x[4] + 4*x[5], GRB.MAXIMIZE)

# Add constraints
resource_data = {
    'r0': {'upper_bound': 181, 'x0': 8, 'x1': 2, 'x2': 13, 'x3': 13, 'x4': 10, 'x5': 5},
    'r1': {'upper_bound': 214, 'x0': 8, 'x1': 11, 'x2': 6, 'x3': 4, 'x4': 1, 'x5': 2},
    'r2': {'upper_bound': 503, 'x0': 9, 'x1': 1, 'x2': 6, 'x3': 13, 'x4': 11, 'x5': 13}
}

for resource, data in resource_data.items():
    m.addConstr(sum(data[f'x{i}'] * x[i] for i in range(6)) <= data['upper_bound'], resource)


constraints = [
    (13*x[3] + 5*x[5], ">=", 23),
    (8*x[0] + 13*x[3], ">=", 30),
    (13*x[2] + 10*x[4], ">=", 29),
    (8*x[0] + 10*x[4], ">=", 13),
    (2*x[1] + 13*x[2], ">=", 26),
    (2*x[1] + 13*x[3], ">=", 22),
    (8*x[0] + 5*x[5], ">=", 21),
    (8*x[0] + 11*x[1] + 4*x[3], ">=", 32),
    (8*x[0] + 4*x[3] + 2*x[5], ">=", 32),
    (6*x[2] + 1*x[4] + 2*x[5], ">=", 32),
    # ... (rest of the constraints)
]

for expr, sense, rhs in constraints:
    if sense == ">=":
        m.addConstr(expr >= rhs)
    elif sense == "<=":
        m.addConstr(expr <= rhs)
    elif sense == "=":
        m.addConstr(expr == rhs)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

