
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="rotisserie_chickens", lb=0)
x1 = m.addVar(name="bananas", lb=0)
x2 = m.addVar(name="bowls_of_instant_ramen", lb=0)
x3 = m.addVar(name="bowls_of_pasta", lb=0)
x4 = m.addVar(name="strips_of_bacon", lb=0)
x5 = m.addVar(name="ham_sandwiches", lb=0)

# Objective function
m.setObjective(1*x0 + 1*x1 + 9*x2 + 6*x3 + 7*x4 + 4*x5, gurobi.GRB.MAXIMIZE)

# Constraints
# Protein constraints
m.addConstr(8*x0 + 2*x1 + 13*x2 + 13*x3 + 10*x4 + 5*x5 <= 181)
m.addConstr(13*x3 + 5*x5 >= 23)
m.addConstr(8*x0 + 13*x3 >= 30)
m.addConstr(13*x2 + 10*x4 >= 29)
m.addConstr(8*x0 + 10*x4 >= 13)
m.addConstr(2*x1 + 13*x2 >= 26)
m.addConstr(2*x1 + 13*x3 >= 22)
m.addConstr(8*x0 + 5*x5 >= 21)

# Cost constraints
m.addConstr(8*x0 + 11*x1 + 6*x2 + 4*x3 + x4 + 2*x5 <= 214)
m.addConstr(8*x0 + x4 <= 70)
m.addConstr(8*x0 + 4*x3 <= 73)
m.addConstr(6*x2 + 2*x5 <= 117)
m.addConstr(x4 + 2*x5 <= 63)
m.addConstr(8*x0 + 11*x1 + 4*x3 >= 32)
m.addConstr(8*x0 + 4*x3 + 2*x5 >= 32)
m.addConstr(6*x2 + x4 + 2*x5 >= 32)
m.addConstr(8*x0 + 11*x1 + 4*x3 >= 30)
m.addConstr(8*x0 + 4*x3 + 2*x5 >= 30)
m.addConstr(6*x2 + x4 + 2*x5 >= 30)

# Fat constraints
m.addConstr(9*x0 + x1 + 6*x2 + 13*x3 + 11*x4 + 13*x5 <= 503)
m.addConstr(11*x4 + 13*x5 >= 60)
m.addConstr(13*x3 + 13*x5 >= 75)
m.addConstr(9*x0 + 6*x2 >= 52)
m.addConstr(9*x0 + 13*x3 + 13*x5 >= 62)
m.addConstr(9*x0 + 6*x2 + 11*x4 >= 62)
m.addConstr(9*x0 + 6*x2 + 13*x5 >= 62)

# Optimization
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("rotisserie chickens: ", x0.varValue)
    print("bananas: ", x1.varValue)
    print("bowls of instant ramen: ", x2.varValue)
    print("bowls of pasta: ", x3.varValue)
    print("strips of bacon: ", x4.varValue)
    print("ham sandwiches: ", x5.varValue)
else:
    print("No solution found")
