
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    planners = m.addVar(vtype=GRB.INTEGER, name="planners")
    color_printers = m.addVar(vtype=GRB.INTEGER, name="color_printers")

    # Set objective function
    m.setObjective(7 * planners + 1 * color_printers, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(20 * planners + 1 * color_printers >= 33, "c0")
    m.addConstr(7 * planners + 1 * color_printers >= 56, "c1")
    m.addConstr(12 * planners + 19 * color_printers >= 84, "c2")
    m.addConstr(13 * planners + 20 * color_printers >= 63, "c3")
    m.addConstr(17 * planners + 13 * color_printers >= 86, "c4")
    m.addConstr(-1 * planners + 7 * color_printers >= 0, "c5")
    m.addConstr(20 * planners + 1 * color_printers <= 44, "c6")
    m.addConstr(7 * planners + 1 * color_printers <= 136, "c7")
    m.addConstr(12 * planners + 19 * color_printers <= 122, "c8")
    m.addConstr(13 * planners + 20 * color_printers <= 100, "c9")
    m.addConstr(17 * planners + 13 * color_printers <= 104, "c10")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('planners:', planners.x)
        print('color_printers:', color_printers.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
