
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="planners", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="color_printers", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7 * x1 + x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * x1 + x2 >= 33, name="usefulness_rating")
m.addConstr(7 * x1 + x2 >= 56, name="dollar_cost")
m.addConstr(12 * x1 + 19 * x2 >= 84, name="employee_satisfaction_impact")
m.addConstr(13 * x1 + 20 * x2 >= 63, name="workplace_safety_impact")
m.addConstr(17 * x1 + 13 * x2 >= 86, name="weight")
m.addConstr(-x1 + 7 * x2 >= 0, name="planners_vs_color_printers")
m.addConstr(20 * x1 + x2 <= 44, name="max_usefulness_rating")
m.addConstr(7 * x1 + x2 <= 136, name="max_dollar_cost")
m.addConstr(12 * x1 + 19 * x2 <= 122, name="max_employee_satisfaction_impact")
m.addConstr(13 * x1 + 20 * x2 <= 100, name="max_workplace_safety_impact")
m.addConstr(17 * x1 + 13 * x2 <= 104, name="max_weight")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Planners: {x1.varValue}")
    print(f"Color Printers: {x2.varValue}")
    print(f"Objective Function: {m.objVal}")
else:
    print("No optimal solution found.")
