
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
napkins = m.addVar(vtype=gp.GRB.INTEGER, name="napkins")
ibuprofen = m.addVar(vtype=gp.GRB.INTEGER, name="ibuprofen")
plates = m.addVar(vtype=gp.GRB.INTEGER, name="plates")

# Set objective function
m.setObjective(5.02 * diapers + 2.81 * napkins + 8.52 * ibuprofen + 9.37 * plates, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(13.13 * ibuprofen + 15.03 * plates >= 74)
m.addConstr(2.37 * napkins + 9.82 * plates >= 42)
m.addConstr(9.5 * diapers + 4.94 * ibuprofen + 9.82 * plates >= 33)
m.addConstr(9.5 * diapers + 2.37 * napkins + 4.94 * ibuprofen >= 33)
m.addConstr(2.37 * napkins + 4.94 * ibuprofen + 9.82 * plates >= 33)
m.addConstr(9.5 * diapers + 4.94 * ibuprofen + 9.82 * plates >= 63)
m.addConstr(9.5 * diapers + 2.37 * napkins + 4.94 * ibuprofen >= 63)
m.addConstr(2.37 * napkins + 4.94 * ibuprofen + 9.82 * plates >= 63)
m.addConstr(9.5 * diapers + 4.94 * ibuprofen + 9.82 * plates >= 58)
m.addConstr(9.5 * diapers + 2.37 * napkins + 4.94 * ibuprofen >= 58)
m.addConstr(2.37 * napkins + 4.94 * ibuprofen + 9.82 * plates >= 58)
m.addConstr(0.53 * diapers + 14.72 * ibuprofen + 7.51 * plates >= 59)
m.addConstr(1.45 * napkins + 15.03 * plates <= 126)
m.addConstr(13.13 * ibuprofen + 15.03 * plates <= 230)
m.addConstr(6.1 * diapers + 15.03 * plates <= 90)
m.addConstr(1.45 * napkins + 13.13 * ibuprofen <= 300)
m.addConstr(6.1 * diapers + 1.45 * napkins + 13.13 * ibuprofen <= 229)
m.addConstr(6.1 * diapers + 1.45 * napkins + 13.13 * ibuprofen + 15.03 * plates <= 229)
m.addConstr(9.5 * diapers + 2.37 * napkins <= 148)
m.addConstr(9.5 * diapers + 9.82 * plates <= 125)
m.addConstr(4.94 * ibuprofen + 9.82 * plates <= 73)
m.addConstr(2.37 * napkins + 4.94 * ibuprofen <= 252)
m.addConstr(9.5 * diapers + 2.37 * napkins + 4.94 * ibuprofen + 9.82 * plates <= 252)
m.addConstr(0.53 * diapers + 14.72 * ibuprofen <= 219)
m.addConstr(10.77 * napkins + 7.51 * plates <= 240)
m.addConstr(0.53 * diapers + 7.51 * plates <= 174)
m.addConstr(10.77 * napkins + 14.72 * ibuprofen <= 119)
m.addConstr(14.72 * ibuprofen + 7.51 * plates <= 176)
m.addConstr(0.53 * diapers + 10.77 * napkins + 14.72 * ibuprofen <= 140)
m.addConstr(0.53 * diapers + 10.77 * napkins + 14.72 * ibuprofen + 7.51 * plates <= 140)


# Resource Constraints from the context section
m.addConstr(6.1 * diapers + 1.45 * napkins + 13.13 * ibuprofen + 15.03 * plates <= 330)
m.addConstr(9.5 * diapers + 2.37 * napkins + 4.94 * ibuprofen + 9.82 * plates <= 262)
m.addConstr(0.53 * diapers + 10.77 * napkins + 14.72 * ibuprofen + 7.51 * plates <= 246)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

