
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="packs of napkins", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="bottles of ibuprofen", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="packs of paper plates", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5.02*x0 + 2.81*x1 + 8.52*x2 + 9.37*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6.1*x0 <= 330)
    model.addConstr(9.5*x0 <= 262)
    model.addConstr(0.53*x0 <= 246)
    model.addConstr(1.45*x1 <= 330)
    model.addConstr(2.37*x1 <= 262)
    model.addConstr(10.77*x1 <= 246)
    model.addConstr(13.13*x2 <= 330)
    model.addConstr(4.94*x2 <= 262)
    model.addConstr(14.72*x2 <= 246)
    model.addConstr(15.03*x3 <= 330)
    model.addConstr(9.82*x3 <= 262)
    model.addConstr(7.51*x3 <= 246)
    model.addConstr(13.13*x2 + 15.03*x3 >= 74)
    model.addConstr(2.37*x1 + 9.82*x3 >= 42)
    model.addConstr(9.5*x0 + 4.94*x2 + 9.82*x3 >= 33)
    model.addConstr(9.5*x0 + 2.37*x1 + 4.94*x2 >= 33)
    model.addConstr(9.5*x0 + 4.94*x2 + 9.82*x3 >= 33)
    model.addConstr(9.5*x0 + 2.37*x1 + 4.94*x2 >= 63)
    model.addConstr(2.37*x1 + 4.94*x2 + 9.82*x3 >= 63)
    model.addConstr(9.5*x0 + 4.94*x2 + 9.82*x3 >= 58)
    model.addConstr(9.5*x0 + 2.37*x1 + 4.94*x2 >= 58)
    model.addConstr(2.37*x1 + 4.94*x2 + 9.82*x3 >= 58)
    model.addConstr(9.5*x0 + 4.94*x2 + 9.82*x3 >= 59)
    model.addConstr(1.45*x1 + 15.03*x3 <= 126)
    model.addConstr(13.13*x2 + 15.03*x3 <= 230)
    model.addConstr(6.1*x0 + 15.03*x3 <= 90)
    model.addConstr(1.45*x1 + 13.13*x2 <= 300)
    model.addConstr(6.1*x0 + 1.45*x1 + 13.13*x2 <= 229)
    model.addConstr(6.1*x0 + 1.45*x1 + 13.13*x2 + 15.03*x3 <= 229)
    model.addConstr(9.5*x0 + 2.37*x1 <= 148)
    model.addConstr(9.5*x0 + 9.82*x3 <= 125)
    model.addConstr(4.94*x2 + 9.82*x3 <= 73)
    model.addConstr(2.37*x1 + 4.94*x2 <= 252)
    model.addConstr(9.5*x0 + 2.37*x1 + 4.94*x2 + 9.82*x3 <= 252)
    model.addConstr(9.5*x0 + 4.94*x2 <= 219)
    model.addConstr(2.37*x1 + 9.82*x3 <= 240)
    model.addConstr(9.5*x0 + 9.82*x3 <= 174)
    model.addConstr(2.37*x1 + 4.94*x2 <= 119)
    model.addConstr(4.94*x2 + 9.82*x3 <= 176)
    model.addConstr(9.5*x0 + 2.37*x1 + 4.94*x2 <= 140)
    model.addConstr(9.5*x0 + 2.37*x1 + 4.94*x2 + 9.82*x3 <= 140)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Diapers: ", x0.varValue)
        print("Packs of napkins: ", x1.varValue)
        print("Bottles of ibuprofen: ", x2.varValue)
        print("Packs of paper plates: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
