
import gurobipy as gp

# Create a new model
m = gp.Model("maximize_tastiness")

# Create variables
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
cherry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")


# Set objective function
m.setObjective(1.22 * protein_bars + 9.67 * cherry_pies + 4.35 * oreos + 7.44 * potatoes + 4.36 * strawberries, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * cherry_pies + 4 * strawberries <= 514, "c1")
m.addConstr(17 * oreos + 4 * strawberries <= 161, "c2")
m.addConstr(9 * cherry_pies + 17 * oreos + 4 * strawberries <= 272, "c3")
m.addConstr(10 * protein_bars + 9 * cherry_pies + 19 * potatoes <= 504, "c4")
m.addConstr(10 * protein_bars + 19 * potatoes + 4 * strawberries <= 289, "c5")
m.addConstr(9 * cherry_pies + 19 * potatoes + 4 * strawberries <= 606, "c6")
m.addConstr(10 * protein_bars + 9 * cherry_pies + 17 * oreos + 19 * potatoes + 4 * strawberries <= 660, "c7")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

