
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='protein_bars', lb=0)  # No upper bound for x1, x2, x3, x4, x5 as they are not provided
    x2 = model.addVar(name='cherry_pies', lb=0)
    x3 = model.addVar(name='oreos', lb=0)
    x4 = model.addVar(name='potatoes', lb=0)
    x5 = model.addVar(name='strawberries', lb=0)

    # Define the objective function
    model.setObjective(1.22*x1 + 9.67*x2 + 4.35*x3 + 7.44*x4 + 4.36*x5, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*x1 <= 660, name='tastiness_rating_protein_bars')
    model.addConstr(9*x2 <= 660, name='tastiness_rating_cherry_pies')
    model.addConstr(17*x3 <= 660, name='tastiness_rating_oreos')
    model.addConstr(19*x4 <= 660, name='tastiness_rating_potatoes')
    model.addConstr(4*x5 <= 660, name='tastiness_rating_strawberries')
    model.addConstr(9*x2 + 4*x5 <= 514, name='combined_tastiness_cherry_pies_strawberries')
    model.addConstr(17*x3 + 4*x5 <= 161, name='combined_tastiness_oreos_strawberries')
    model.addConstr(9*x2 + 17*x3 + 4*x5 <= 272, name='combined_tastiness_cherry_pies_oreos_strawberries')
    model.addConstr(10*x1 + 9*x2 + 19*x4 <= 504, name='combined_tastiness_protein_bars_cherry_pies_potatoes')
    model.addConstr(10*x1 + 19*x4 + 4*x5 <= 289, name='combined_tastiness_protein_bars_potatoes_strawberries')
    model.addConstr(9*x2 + 19*x4 + 4*x5 <= 606, name='combined_tastiness_cherry_pies_potatoes_strawberries')
    model.addConstr(10*x1 + 9*x2 + 17*x3 + 19*x4 + 4*x5 <= 606, name='combined_tastiness_all')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Protein bars: ', x1.varValue)
        print('Cherry pies: ', x2.varValue)
        print('Oreos: ', x3.varValue)
        print('Potatoes: ', x4.varValue)
        print('Strawberries: ', x5.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
