
import gurobipy as gp

# Create a new model
model = gp.Model("resource_allocation")

# Create variables
soc_operators = model.addVar(vtype=gp.GRB.INTEGER, name="SOC_operators")
network_admins = model.addVar(vtype=gp.GRB.INTEGER, name="Network_admins")
patches_per_day = model.addVar(vtype=gp.GRB.INTEGER, name="Patches_per_day")
automatic_alerts = model.addVar(vtype=gp.GRB.INTEGER, name="Automatic_alerts")


# Set objective function
model.setObjective(3.33 * soc_operators + 4.21 * network_admins + 5.7 * patches_per_day + 8.51 * automatic_alerts, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * soc_operators + 2 * network_admins + 4 * patches_per_day + 6 * automatic_alerts <= 72, "Network Integrity Impact")
model.addConstr(5 * soc_operators + 3 * network_admins + 1 * patches_per_day + 6 * automatic_alerts <= 66, "Data Integrity Impact")
model.addConstr(2 * soc_operators + 7 * network_admins + 4 * patches_per_day + 6 * automatic_alerts <= 52, "Available Bandwidth Impact")
model.addConstr(2 * soc_operators + 1 * network_admins + 4 * patches_per_day + 5 * automatic_alerts <= 45, "Computational Load")

# ... (Add all other constraints similarly based on the JSON representation)

# Add the rest of the constraints from the JSON data
constraints_data = { # ... (copy the constraints from the JSON) }

for constraint_str in constraints_data["constraints"]:
    model.addConstr(eval(constraint_str))  # Use eval() to parse the string as a Python expression


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"SOC operators: {soc_operators.x}")
    print(f"Network administrators: {network_admins.x}")
    print(f"Patches per day: {patches_per_day.x}")
    print(f"Automatic alerts: {automatic_alerts.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

