
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="bowls_of_pasta")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="potatoes")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="bagged_salads")


    # Set objective function
    m.setObjective(8*x0 + 9*x1 + 5*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12*x0 + 17*x2 >= 48, "c0")
    m.addConstr(12*x0 + 6*x1 + 17*x2 >= 55, "c1")
    m.addConstr(6*x0 - 9*x2 >= 0, "c2")
    m.addConstr(12*x1 + 3*x2 <= 376, "c3")
    m.addConstr(23*x0 + 3*x2 <= 443, "c4")
    m.addConstr(23*x0 + 12*x1 <= 239, "c5")
    m.addConstr(23*x0 + 12*x1 + 3*x2 <= 239, "c6")
    m.addConstr(6*x1 + 17*x2 <= 85, "c7")
    m.addConstr(12*x0 + 6*x1 + 17*x2 <= 85, "c8")
    m.addConstr(23 * x0 <= 474, "protein_pasta")
    m.addConstr(12 * x0 <= 188, "iron_pasta")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
