
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="bowls_of_pasta", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="potatoes", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="bagged_salads", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8*x0 + 9*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*x0 + 17*x2 >= 48, name="iron_from_pasta_salads")
    model.addConstr(12*x0 + 6*x1 + 17*x2 >= 55, name="total_iron")
    model.addConstr(6*x0 - 9*x2 >= 0, name="pasta_salads_balance")
    model.addConstr(12*x1 + 3*x2 <= 376, name="protein_from_potatoes_salads")
    model.addConstr(23*x0 + 3*x2 <= 443, name="protein_from_pasta_salads")
    model.addConstr(23*x0 + 12*x1 <= 239, name="protein_from_pasta_potatoes")
    model.addConstr(23*x0 + 12*x1 + 3*x2 <= 239, name="total_protein")
    model.addConstr(6*x1 + 17*x2 <= 85, name="iron_from_potatoes_salads")
    model.addConstr(12*x0 + 6*x1 + 17*x2 <= 85, name="total_iron_limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bowls of pasta: ", x0.varValue)
        print("potatoes: ", x1.varValue)
        print("bagged salads: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
