
import gurobipy as gp

# Create a new model
m = gp.Model("flower_optimization")

# Create variables
vincas = m.addVar(vtype=gp.GRB.INTEGER, name="vincas")
ferns = m.addVar(vtype=gp.GRB.INTEGER, name="ferns")
petunias = m.addVar(vtype=gp.GRB.INTEGER, name="petunias")
daisies = m.addVar(vtype=gp.GRB.INTEGER, name="daisies")

# Set objective function
m.setObjective(7.59 * vincas + 6.13 * ferns + 2.19 * petunias + 7.82 * daisies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.32 * ferns + 4.7 * daisies >= 53)
m.addConstr(7.69 * vincas + 7.99 * petunias >= 57)
m.addConstr(7.69 * vincas + 4.7 * daisies >= 49)
m.addConstr(7.69 * vincas + 2.32 * ferns + 7.99 * petunias + 4.7 * daisies >= 49)
m.addConstr(8.06 * vincas + 4.74 * petunias >= 47)
m.addConstr(1.47 * ferns + 4.74 * petunias + 3.12 * daisies >= 45)
m.addConstr(8.06 * vincas + 4.74 * petunias + 3.12 * daisies >= 45)
m.addConstr(1.47 * ferns + 4.74 * petunias + 3.12 * daisies >= 53)
m.addConstr(8.06 * vincas + 4.74 * petunias + 3.12 * daisies >= 53)
m.addConstr(8.06 * vincas + 1.47 * ferns + 4.74 * petunias + 3.12 * daisies >= 53)
m.addConstr(7.69 * vincas + 4.7 * daisies <= 80)
m.addConstr(2.32 * ferns + 7.99 * petunias + 4.7 * daisies <= 69)
m.addConstr(7.69 * vincas + 7.99 * petunias + 4.7 * daisies <= 102)
m.addConstr(7.69 * vincas + 2.32 * ferns + 4.7 * daisies <= 173)
m.addConstr(1.47 * ferns + 3.12 * daisies <= 211)
m.addConstr(8.06 * vincas + 1.47 * ferns <= 97)
m.addConstr(4.74 * petunias + 3.12 * daisies <= 92)
m.addConstr(1.47 * ferns + 4.74 * petunias <= 200)
m.addConstr(8.06 * vincas + 4.74 * petunias <= 69)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vincas:', vincas.x)
    print('ferns:', ferns.x)
    print('petunias:', petunias.x)
    print('daisies:', daisies.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
