
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="vincas", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="ferns", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="petunias", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="daisies", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(7.59*x0 + 6.13*x1 + 2.19*x2 + 7.82*x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2.32*x1 + 4.7*x3 >= 53)
    model.addConstr(7.69*x0 + 7.99*x2 >= 57)
    model.addConstr(7.69*x0 + 4.7*x3 >= 49)
    model.addConstr(7.69*x0 + 2.32*x1 + 7.99*x2 + 4.7*x3 >= 49)
    model.addConstr(8.06*x0 + 4.74*x2 >= 47)
    model.addConstr(1.47*x1 + 4.74*x2 + 3.12*x3 >= 45)
    model.addConstr(8.06*x0 + 4.74*x2 + 3.12*x3 >= 45)
    model.addConstr(1.47*x1 + 4.74*x2 + 3.12*x3 >= 53)
    model.addConstr(8.06*x0 + 4.74*x2 + 3.12*x3 >= 53)
    model.addConstr(8.06*x0 + 1.47*x1 + 4.74*x2 + 3.12*x3 >= 53)
    model.addConstr(7.69*x0 + 4.7*x3 <= 80)
    model.addConstr(2.32*x1 + 7.99*x2 + 4.7*x3 <= 69)
    model.addConstr(7.69*x0 + 7.99*x2 + 4.7*x3 <= 102)
    model.addConstr(7.69*x0 + 2.32*x1 + 4.7*x3 <= 173)
    model.addConstr(1.47*x1 + 3.12*x3 <= 211)
    model.addConstr(8.06*x0 + 1.47*x1 <= 97)
    model.addConstr(4.74*x2 + 3.12*x3 <= 92)
    model.addConstr(1.47*x1 + 4.74*x2 <= 200)
    model.addConstr(8.06*x0 + 4.74*x2 <= 69)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Vincas: ", x0.varValue)
        print("Ferns: ", x1.varValue)
        print("Petunias: ", x2.varValue)
        print("Daisies: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
