
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")

    # Set objective function
    m.setObjective(4 * vitamin_c + 4 * zinc + 1 * magnesium + 9 * vitamin_e, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(14 * zinc + 16 * magnesium >= 34)
    m.addConstr(18 * vitamin_c + 16 * magnesium >= 20)
    m.addConstr(18 * vitamin_c + 16 * magnesium + 19 * vitamin_e >= 41)
    m.addConstr(16 * vitamin_c + 18 * zinc + 1 * magnesium >= 34)
    m.addConstr(16 * vitamin_c + 18 * zinc + 14 * vitamin_e >= 34)
    m.addConstr(16 * vitamin_c + 18 * zinc + 1 * magnesium >= 41)
    m.addConstr(16 * vitamin_c + 18 * zinc + 14 * vitamin_e >= 41)
    m.addConstr(18 * vitamin_c + 18 * vitamin_e >= 32)
    m.addConstr(18 * vitamin_c + 18 * magnesium >= 23)
    m.addConstr(19 * zinc + 18 * magnesium >= 42)
    m.addConstr(18 * vitamin_c + 19 * zinc >= 21)
    m.addConstr(14 * zinc + 16 * magnesium <= 74)
    m.addConstr(16 * magnesium + 19 * vitamin_e <= 108)
    m.addConstr(14 * zinc + 19 * vitamin_e <= 71)
    m.addConstr(18 * vitamin_c + 19 * vitamin_e <= 172)
    m.addConstr(18 * vitamin_c + 14 * zinc + 16 * magnesium + 19 * vitamin_e <= 172)
    m.addConstr(18 * zinc + 14 * vitamin_e <= 75)
    m.addConstr(18 * zinc + 1 * magnesium <= 130)
    m.addConstr(16 * vitamin_c + 1 * magnesium <= 98)
    m.addConstr(1 * magnesium + 14 * vitamin_e <= 174)
    m.addConstr(16 * vitamin_c + 18 * zinc + 14 * vitamin_e <= 118)
    m.addConstr(16 * vitamin_c + 1 * magnesium + 14 * vitamin_e <= 63)
    m.addConstr(16 * vitamin_c + 18 * zinc + 1 * magnesium + 14 * vitamin_e <= 63)
    m.addConstr(19 * zinc + 18 * magnesium <= 162)
    m.addConstr(18 * vitamin_c + 18 * vitamin_e <= 197)
    m.addConstr(18 * vitamin_c + 18 * magnesium <= 147)
    m.addConstr(19 * zinc + 18 * vitamin_e <= 134)
    m.addConstr(18 * vitamin_c + 19 * zinc <= 75)
    m.addConstr(18 * magnesium + 18 * vitamin_e <= 111)
    m.addConstr(18 * vitamin_c + 19 * zinc + 18 * vitamin_e <= 81)
    m.addConstr(18 * vitamin_c + 19 * zinc + 18 * magnesium + 18 * vitamin_e <= 81)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
