
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
corn = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn")
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")


# Set objective function
m.setObjective(8.35 * bacon + 6.13 * corn + 3.25 * bananas, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * bacon + 4 * corn + 2 * bananas <= 65, "fat_upper_bound")
m.addConstr(4 * corn + 2 * bananas >= 21, "corn_banana_fat")
m.addConstr(8 * bacon + 4 * corn >= 9, "bacon_corn_fat")
m.addConstr(8 * bacon + 2 * bananas >= 11, "bacon_banana_fat")
m.addConstr(8 * bacon + 4 * corn + 2 * bananas >= 11, "total_fat")
m.addConstr(10 * bacon - 4 * corn >= 0, "bacon_corn_relation")
m.addConstr(-6 * corn + 3 * bananas >= 0, "corn_banana_relation")
m.addConstr(-1 * bacon + 9 * bananas >= 0, "bacon_banana_relation")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bacon:', bacon.x)
    print('corn:', corn.x)
    print('bananas:', bananas.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

