
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="strips_of_bacon", lb=0)  # strips of bacon
x2 = model.addVar(name="corn_cobs", lb=0)  # corn cobs
x3 = model.addVar(name="bananas", lb=0)  # bananas

# Objective function
model.setObjective(8.35*x1 + 6.13*x2 + 3.25*x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(8*x1 + 4*x2 + 2*x3 <= 65)  # total fat constraint
model.addConstr(4*x2 + 2*x3 >= 21)  # fat from corn cobs and bananas
model.addConstr(8*x1 + 4*x2 >= 9)  # fat from strips of bacon and corn cobs
model.addConstr(8*x1 + 2*x3 >= 11)  # fat from strips of bacon and bananas
model.addConstr(8*x1 + 4*x2 + 2*x3 >= 11)  # fat from all sources
model.addConstr(10*x1 - 4*x2 >= 0)  # constraint on strips of bacon and corn cobs
model.addConstr(-6*x2 + 3*x3 >= 0)  # constraint on corn cobs and bananas
model.addConstr(-x1 + 9*x3 >= 0)  # constraint on strips of bacon and bananas

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Strips of bacon: ", x1.varValue)
    print("Corn cobs: ", x2.varValue)
    print("Bananas: ", x3.varValue)
else:
    print("The model is infeasible")
