
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
    iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")


    # Set objective function
    m.setObjective(6.04 * vitamin_a + 2.29 * iron + 8.63 * vitamin_k, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2 * vitamin_a + 14 * vitamin_k >= 50, "immune_support_a_k")
    m.addConstr(2 * vitamin_a + 13 * iron + 14 * vitamin_k >= 50, "immune_support_all")
    m.addConstr(11 * iron + 5 * vitamin_k >= 43, "cognitive_performance_i_k")
    m.addConstr(9 * vitamin_a + 11 * iron >= 24, "cognitive_performance_a_i")
    m.addConstr(9 * vitamin_a + 11 * iron + 5 * vitamin_k >= 24, "cognitive_performance_all")
    m.addConstr(iron - 10 * vitamin_k >= 0, "iron_vitamin_k_ratio")
    m.addConstr(2 * vitamin_a + 13 * iron <= 105, "immune_support_a_i_ub")
    m.addConstr(2 * vitamin_a + 14 * vitamin_k <= 234, "immune_support_a_k_ub")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin A: %g' % vitamin_a.x)
        print('Iron: %g' % iron.x)
        print('Vitamin K: %g' % vitamin_k.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
