
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_A", lb=-float('inf'))
    x1 = model.addVar(name="milligrams_of_iron", lb=-float('inf'))
    x2 = model.addVar(name="milligrams_of_vitamin_K", lb=-float('inf'))

    # Define the objective function
    model.setObjective(6.04 * x0 + 2.29 * x1 + 8.63 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * x0 <= 249)
    model.addConstr(9 * x0 <= 208)
    model.addConstr(13 * x1 <= 249)
    model.addConstr(11 * x1 <= 208)
    model.addConstr(14 * x2 <= 249)
    model.addConstr(5 * x2 <= 208)
    model.addConstr(2 * x0 + 14 * x2 >= 50)
    model.addConstr(2 * x0 + 13 * x1 + 14 * x2 >= 50)
    model.addConstr(11 * x1 + 5 * x2 >= 43)
    model.addConstr(9 * x0 + 11 * x1 >= 24)
    model.addConstr(9 * x0 + 11 * x1 + 5 * x2 >= 24)
    model.addConstr(x1 - 10 * x2 >= 0)
    model.addConstr(2 * x0 + 13 * x1 <= 105)
    model.addConstr(2 * x0 + 14 * x2 <= 234)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x0.varValue}")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Milligrams of vitamin K: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
