
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milkshakes")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hot_dogs")


    # Set objective function
    m.setObjective(1.23 * x0 + 2.93 * x1 + 7.79 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(19 * x1 + 6 * x2 >= 49, "c1")
    m.addConstr(16 * x0 + 19 * x1 >= 63, "c2")
    m.addConstr(11 * x0 + 25 * x1 >= 54, "c3")
    m.addConstr(25 * x1 + 24 * x2 >= 80, "c4")
    m.addConstr(22 * x0 + 19 * x1 >= 67, "c5")
    m.addConstr(19 * x1 + 6 * x2 <= 231, "c6")
    m.addConstr(16 * x0 + 19 * x1 <= 198, "c7")
    m.addConstr(16 * x0 + 19 * x1 + 6 * x2 <= 198, "c8")
    m.addConstr(11 * x0 + 24 * x2 <= 134, "c9")
    m.addConstr(25 * x1 + 24 * x2 <= 186, "c10")
    m.addConstr(11 * x0 + 25 * x1 + 24 * x2 <= 186, "c11")
    m.addConstr(22 * x0 + 23 * x2 <= 242, "c12")
    m.addConstr(22 * x0 + 19 * x1 <= 206, "c13")
    m.addConstr(22 * x0 + 19 * x1 + 23 * x2 <= 206, "c14")

    # Resource Constraints
    m.addConstr(16 * x0 + 11 * x0 + 22 * x0 <= 272, "r0") # carbs
    m.addConstr(25 * x1 + 24 * x2 <= 280, "r1") # fat
    m.addConstr(19 * x1 + 23 * x2 <= 259, "r2") # calcium


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
