
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='blueberry_pies', lb=0)
    x1 = model.addVar(name='milkshakes', lb=0)
    x2 = model.addVar(name='hot_dogs', lb=0)

    # Define the objective function
    model.setObjective(1.23*x0 + 2.93*x1 + 7.79*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(16*x0 + 19*x1 + 6*x2 <= 272)  # carbohydrates total
    model.addConstr(11*x0 + 25*x1 + 24*x2 <= 280)  # fat total
    model.addConstr(22*x0 + 19*x1 + 23*x2 <= 259)  # calcium total
    model.addConstr(19*x1 + 6*x2 >= 49)  # carbohydrates from milkshakes and hot dogs
    model.addConstr(16*x0 + 19*x1 >= 63)  # carbohydrates from blueberry pies and milkshakes
    model.addConstr(11*x0 + 25*x1 >= 54)  # fat from blueberry pies and milkshakes
    model.addConstr(25*x1 + 24*x2 >= 80)  # fat from milkshakes and hot dogs
    model.addConstr(22*x0 + 19*x1 >= 67)  # calcium from blueberry pies and milkshakes
    model.addConstr(19*x1 + 6*x2 <= 231)  # carbohydrates from milkshakes and hot dogs upper bound
    model.addConstr(16*x0 + 19*x1 <= 198)  # carbohydrates from blueberry pies and milkshakes upper bound
    model.addConstr(11*x0 + 24*x2 <= 134)  # fat from blueberry pies and hot dogs
    model.addConstr(25*x1 + 24*x2 <= 186)  # fat from milkshakes and hot dogs upper bound
    model.addConstr(22*x0 + 23*x2 <= 242)  # calcium from blueberry pies and hot dogs
    model.addConstr(22*x0 + 19*x1 <= 206)  # calcium from blueberry pies and milkshakes

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Blueberry pies: ', x0.varValue)
        print('Milkshakes: ', x1.varValue)
        print('Hot dogs: ', x2.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
